//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0

Item {
    id : delegateItem

    property int        idx             : index
    property alias      mouseArea       : mouseArea
    property alias      hoverEnabled    : mouseArea.hoverEnabled
    property alias      acceptedButtons : mouseArea.acceptedButtons
    property GridView   gridView : {
         //! Delegate can only be used in a SelectionGridView
        if (GridView && GridView.view) {
            return GridView.view;
        }
       throw new Error("Failed to obtain the containing view");
    }


    width : GridView.view.cellWidth
    height : GridView.view.cellHeight

    Keys.forwardTo : gridView
    MouseArea {
        id : mouseArea

        anchors.fill : parent

        QtObject {
            id : p_

            property int  movementX    : -1
            property int  movementY    : -1
            property bool draggingArea : false
        }

        acceptedButtons : Qt.LeftButton | Qt.RightButton
        onPressed : {
            gridView.forceActiveFocus();
            p_.movementX = mouse.x;
            p_.movementY = mouse.y;
            if (mouse.modifiers !== Qt.NoModifier)
                return; // otherwise adding selection with ctrl won't work

            if (gridView.selection.length === 0
                    || gridView.selection.indexOf(document) === -1) {
                gridView.selectDocument(document);
            }
        }
        onPositionChanged : {
            if (mouseArea.pressed) {
                var diffX = Math.abs(p_.movementX - mouse.x);
                var diffY = Math.abs(p_.movementY - mouse.y);

                if (diffX > 5 || diffY > 5)
                    p_.draggingArea = true;
            }
        }

        onClicked : {
            if (p_.draggingArea) {
                p_.draggingArea = false;
                return;
            }

            var oldIndex  = gridView.currentIndex;
            gridView.currentIndex = delegateItem.idx;

            if (mouse.button === Qt.LeftButton) {
                if (mouse.modifiers === Qt.NoModifier
                        || !gridView.multiSelection) {
                    gridView.previousIndex = gridView.currentIndex;
                    gridView.selection = [document];
                    return;
                }

                // Shift + Ctrl selection handling
                if (mouse.modifiers === Qt.ControlModifier) {
                    gridView.previousIndex = gridView.currentIndex;

                    var idx = gridView.selection.indexOf(document);
                    if (idx !== -1) {
                        var selection = gridView.selection;
                        selection.splice(idx, 1);
                        gridView.selection = selection;
                    } else {
                        var i = 0;
                        for (i = 0; i < gridView.selection.length; ++i) {
                            if(gridView.model.indexOf(gridView.selection[i]) > gridView.model.indexOf(document))
                                break;
                        }
                        var newSelection = gridView.selection;
                        newSelection.splice(i, 0, document);
                        gridView.selection = newSelection;
                    }
                } else if (mouse.modifiers ===
                           (Qt.ShiftModifier | Qt.ControlModifier)) {
                    gridView.previousIndex = oldIndex;

                    gridView.selection = gridView.selection.concat(
                                gridView.selectRange(gridView.previousIndex,
                                                     gridView.currentIndex,
                                                     false));
                } else if (mouse.modifiers === Qt.ShiftModifier) {
                    if (gridView.previousIndex === -1)
                        gridView.previousIndex = 0;

                    gridView.selection = gridView.selectRange(
                                gridView.previousIndex, gridView.currentIndex);
                }
            }

            if (mouse.button === Qt.RightButton) {
                // only handle single right click select if not part of selection
                if (gridView.selection.indexOf(document) === -1) {
                    gridView.previousIndex = delegateItem.idx;
                    gridView.currentIndex = delegateItem.idx;
                    gridView.selection = [document];
                }
            }
        } // click handling

    } // mouseArea
}

